/*
 * Decompiled with CFR 0.152.
 */
package javanavtex;

import audiohelpers.WaveTarget;
import decoder.FFTThread;
import decoder.SpectrumTarget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.JComponent;

public class SpectrumView
extends JComponent
implements WaveTarget,
SpectrumTarget {
    protected DecimalFormat tflz;
    protected DecimalFormat tf;
    double[] m_spectrum = null;
    int m_dataLength;
    double m_cursorFrequency = 1000.0;
    double m_deviation = 170.0;
    int m_sampleRate = 11025;
    protected boolean done = false;
    FFTThread m_spectrumThread = new FFTThread(this);

    public SpectrumView() {
        this.m_spectrumThread.setPriority(1);
        this.m_spectrumThread.start();
    }

    public void setSampleRate(int rate) {
        this.m_sampleRate = rate;
        this.repaint();
    }

    public double getFrequency() {
        return this.m_cursorFrequency;
    }

    public void setFrequency(double f) {
        f = this.m_cursorFrequency;
        this.repaint();
    }

    public void stop() {
        this.done = true;
    }

    public void waveReady(double[] data, int length) {
        Thread.State state = this.m_spectrumThread.getState();
        if (state == Thread.State.WAITING) {
            this.m_spectrumThread.waveReady(data, length);
        }
    }

    public void spectrumReady(double[] data, int length) {
        this.m_spectrum = data;
        this.m_dataLength = length;
        this.repaint();
    }

    public void onMouseClick(MouseEvent evt) {
        Point point = evt.getPoint();
        this.setFrequencyFromPoint(point);
        this.repaint();
    }

    private void setFrequencyFromPoint(Point p) {
        double f = this.screenToFrequency(p.x);
        if (f > this.m_deviation / 2.0 && f < (double)(this.m_sampleRate / 2) - this.m_deviation / 2.0) {
            this.m_cursorFrequency = f;
        }
    }

    protected double screenToFrequency(int x) {
        Dimension size = this.getSize();
        double f = (double)(this.m_sampleRate / 2) / (double)size.width;
        return f *= (double)x;
    }

    protected int frequencyToScreen(double f) {
        Dimension size = this.getSize();
        double x = (double)size.width / (double)(this.m_sampleRate / 2);
        return (int)(x *= f);
    }

    protected void drawCursor(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(Color.white);
        String s = String.format("%dHz", (int)this.m_cursorFrequency);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int x = this.frequencyToScreen(this.m_cursorFrequency);
        g.drawString(s, x -= fm.stringWidth(s) / 2, size.height - 1);
        g.setColor(Color.red);
        x = this.frequencyToScreen(this.m_cursorFrequency);
        g.drawLine(x, 1, x, size.height - fm.getAscent());
        g.setColor(Color.yellow);
        x = this.frequencyToScreen(this.m_cursorFrequency - this.m_deviation / 2.0);
        g.drawLine(x, size.height / 3, x, size.height - fm.getAscent());
        x = this.frequencyToScreen(this.m_cursorFrequency + this.m_deviation / 2.0);
        g.drawLine(x, size.height / 3, x, size.height - fm.getAscent());
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(Color.black);
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(Color.cyan);
        if (this.m_spectrum == null) {
            g.drawLine(0, size.height - 1, size.width, size.height - 1);
            this.drawCursor(g);
            return;
        }
        double scale = size.height;
        int oldptr = 0;
        double xScale = (double)this.m_dataLength / (double)size.width;
        for (int n = 1; n < size.width; ++n) {
            int ptr = (int)(xScale * (double)n);
            g.drawLine(n - 1, size.height - (int)(scale * this.m_spectrum[oldptr]), n, size.height - (int)(scale * this.m_spectrum[ptr]));
            oldptr = ptr;
        }
        this.drawCursor(g);
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, 10);
    }
}

