/*
 * Decompiled with CFR 0.152.
 */
package javanavtex;

import audiohelpers.AudioUtils;
import audiohelpers.WaveTarget;
import decoder.DataTarget;
import decoder.DecoderThread;
import decoder.TextTarget;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javanavtex.DataView;
import javanavtex.MessageBox;
import javanavtex.SpectrumView;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.jdesktop.layout.GroupLayout;

public class JavaNavtexUI
extends JFrame
implements ActionListener,
WaveTarget,
DataTarget,
TextTarget {
    DecoderThread m_decoder;
    AudioUtils m_audioUtils;
    private static final int BASE_SAMPLE_RATE = 11025;
    private int m_sampleRate;
    private static final int[] m_preferredSampleRates = new int[]{11025, 22050, 44100, -1};
    private static final String VERSION = "0.2 BETA";
    private DataView dataView1;
    private JMenuBar jMenuBar1;
    private JTextArea jMessageArea;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JMenu jSoundDeviceMenu;
    private JSplitPane jSplitPane1;
    private JTextPane jTextPane1;
    private SpectrumView spectrumView1;

    public JavaNavtexUI() {
        this.initComponents();
        this.m_decoder = null;
        this.spectrumView1.setFrequency(1085.0);
        this.jTextPane1.setEditable(false);
        this.addStylesToDocument(this.jTextPane1.getStyledDocument());
        this.writeSystemProperty("java.version");
        this.writeSystemProperty("java.vendor");
        this.writeSystemProperty("java.vm.vendor");
        this.writeSystemProperty("java.vm.name");
        this.writeSystemProperty("java.vm.version");
        this.writeSystemProperty("java.vm.info");
        this.writeSystemProperty("java.vm.specification.vendor");
        this.writeSystemProperty("java.vm.specification.name");
        this.writeSystemProperty("java.vm.specification.version");
        this.writeSystemProperty("java.specification.vendor");
        this.writeSystemProperty("java.specification.name");
        this.writeSystemProperty("java.specification.version");
        this.writeSystemProperty("java.runtime.name");
        this.writeSystemProperty("java.runtime.version");
        this.writeSystemProperty("user.country");
        this.writeSystemProperty("user.variant");
        this.writeSystemProperty("user.language");
        this.writeSystemProperty("sun.java.launcher");
        this.writeSystemProperty("sun.jnu.encoding");
        this.writeSystemProperty("os.name");
        this.writeSystemProperty("os.version");
        this.writeSystemProperty("sun.os.patch.level");
        this.writeSystemProperty("sun.desktop");
        this.writeSystemProperty("sun.cpu.endian");
        this.writeSystemProperty("sun.cpu.isalist");
        this.writeSystemProperty("sun.io.unicode.encoding");
        this.writeSystemMessage("\n");
        this.writeFriendlyMessage(this.getAboutString());
        this.writeSystemMessage("\n***********************************************************************\n* See http://www.frisnit.com/navtex/ for updates and more information *\n* Please email bug (and success!) reports to bugreports@frisnit.com   *\n* Include ALL the contents of this window in any reports. Thanks!     *\n***********************************************************************\n");
        this.writeErrorMessage("Select a sound device from the menu to begin decoding.\n\n");
        int n = 0;
        String[] name = new String[]{""};
        while (AudioUtils.getDeviceName(n, name) > 0) {
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText(name[0]);
            menuItem.addActionListener(this);
            this.jSoundDeviceMenu.add(menuItem);
            ++n;
        }
    }

    private void writeSystemProperty(String prop) {
        this.writeSystemMessage(prop + " = " + System.getProperty(prop) + "\n");
    }

    private String getAboutString() {
        return new String("Ahoy there!\n\nNAVTEX Decoder Java Edition version 0.2 BETA\n(C)2007 Mark Longstaff-Tyrrell\n\n");
    }

    public void waveReady(double[] data, int length) {
        if (length == -1) {
            this.writeErrorMessage("\n[CPU LOW]");
            return;
        }
        this.spectrumView1.waveReady(data, length);
        if (this.m_decoder != null) {
            while (this.m_decoder.getState() != Thread.State.WAITING) {
            }
            Thread.State state = this.m_decoder.getState();
            if (state == Thread.State.WAITING) {
                this.m_decoder.waveReady(data, length);
            }
        }
    }

    public void dataReady(double[] data, int length) {
        this.dataView1.dataReady(data, length);
    }

    private void writeFormattedText(String text, String style) {
        StyledDocument doc = this.jTextPane1.getStyledDocument();
        try {
            doc.insertString(doc.getLength(), text, doc.getStyle(style));
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
    }

    protected void addStylesToDocument(StyledDocument doc) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("normal", def);
        StyleConstants.setFontFamily(def, "Monospaced");
        Style s = doc.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = doc.addStyle("message", regular);
        StyleConstants.setFontSize(s, 12);
        StyleConstants.setBold(s, false);
        StyleConstants.setForeground(s, new Color(0, 196, 0, 255));
        s = doc.addStyle("data", regular);
        StyleConstants.setFontSize(s, 12);
        StyleConstants.setBold(s, false);
        StyleConstants.setForeground(s, new Color(0, 0, 196, 255));
        s = doc.addStyle("error", regular);
        StyleConstants.setFontSize(s, 12);
        StyleConstants.setBold(s, true);
        StyleConstants.setForeground(s, new Color(196, 0, 0, 255));
        s = doc.addStyle("friendly", regular);
        StyleConstants.setFontSize(s, 16);
        StyleConstants.setBold(s, true);
        StyleConstants.setItalic(s, true);
        StyleConstants.setForeground(s, new Color(96, 96, 96, 255));
        StyleConstants.setFontFamily(s, "SansSerif");
    }

    public void textReady(String text) {
        boolean locked = false;
        JScrollBar scrollBar = this.jScrollPane3.getVerticalScrollBar();
        int pos = scrollBar.getValue();
        int maxpos = scrollBar.getMaximum();
        int amount = scrollBar.getVisibleAmount();
        if (amount + pos + 10 >= maxpos) {
            locked = true;
        }
        this.writeFormattedText(text, "data");
        if (locked) {
            this.jTextPane1.setCaretPosition(this.jTextPane1.getDocument().getLength());
        }
    }

    private void writeSystemMessage(String text) {
        this.writeFormattedText(text, "message");
    }

    private void writeFriendlyMessage(String text) {
        this.writeFormattedText(text, "friendly");
    }

    private void writeErrorMessage(String text) {
        this.writeFormattedText(text, "error");
    }

    public void actionPerformed(ActionEvent event) {
        if (this.m_audioUtils != null) {
            this.writeSystemMessage("\nStopping sound input device\n");
            this.m_audioUtils.StopAudio();
        }
        int n = 0;
        while (m_preferredSampleRates[n] > 0) {
            this.m_sampleRate = m_preferredSampleRates[n];
            int oversample_rate = this.m_sampleRate / 11025;
            if (oversample_rate < 1) {
                oversample_rate = 1;
            }
            this.m_audioUtils = new AudioUtils(this.m_sampleRate / oversample_rate, oversample_rate);
            this.writeSystemMessage("Trying sound capture at " + String.valueOf(this.m_sampleRate) + "Hz...");
            if (this.m_audioUtils.StartAudio(event.getActionCommand(), this)) {
                this.writeSystemMessage("Success!\nStarting decoder using " + event.getActionCommand() + " at " + String.valueOf(this.m_sampleRate) + "Hz (" + String.valueOf(oversample_rate) + "x oversampling)\n\n");
                this.spectrumView1.setSampleRate(this.m_sampleRate / oversample_rate);
                this.m_audioUtils.setPriority(10);
                if (this.m_decoder != null) break;
                this.m_decoder = new DecoderThread(this.m_sampleRate / oversample_rate, 1000.0, 170.0, this, this);
                this.m_decoder.setPriority(10);
                break;
            }
            this.writeErrorMessage("Failed\n");
            ++n;
        }
        if (m_preferredSampleRates[n] < 0) {
            this.writeErrorMessage("ERROR: Can't open sound device '" + event.getActionCommand() + "'\n");
            MessageBox message = new MessageBox(new Frame(""), "Error", "Can't open sound device '" + event.getActionCommand() + "'", false);
            this.requestFocus();
            message.dispose();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jMessageArea = new JTextArea();
        this.jSplitPane1 = new JSplitPane();
        this.spectrumView1 = new SpectrumView();
        this.dataView1 = new DataView();
        this.jScrollPane3 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jMenuBar1 = new JMenuBar();
        this.jSoundDeviceMenu = new JMenu();
        this.jMessageArea.setColumns(20);
        this.jMessageArea.setRows(5);
        this.jScrollPane1.setViewportView(this.jMessageArea);
        this.setDefaultCloseOperation(3);
        this.setTitle("Frisnit NAVTEX Decoder Java Edition");
        this.jSplitPane1.setDividerLocation(400);
        this.spectrumView1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JavaNavtexUI.this.spectrumView1MouseClicked(evt);
            }
        });
        this.spectrumView1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                JavaNavtexUI.this.spectrumView1MouseDragged(evt);
            }
        });
        GroupLayout spectrumView1Layout = new GroupLayout(this.spectrumView1);
        this.spectrumView1.setLayout(spectrumView1Layout);
        spectrumView1Layout.setHorizontalGroup(spectrumView1Layout.createParallelGroup(1).add(0, 399, Short.MAX_VALUE));
        spectrumView1Layout.setVerticalGroup(spectrumView1Layout.createParallelGroup(1).add(0, 74, Short.MAX_VALUE));
        this.jSplitPane1.setLeftComponent(this.spectrumView1);
        GroupLayout dataView1Layout = new GroupLayout(this.dataView1);
        this.dataView1.setLayout(dataView1Layout);
        dataView1Layout.setHorizontalGroup(dataView1Layout.createParallelGroup(1).add(0, 251, Short.MAX_VALUE));
        dataView1Layout.setVerticalGroup(dataView1Layout.createParallelGroup(1).add(0, 74, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.dataView1);
        this.jScrollPane3.setViewportView(this.jTextPane1);
        this.jMenuBar1.setFont(new Font("Arial", 0, 11));
        this.jSoundDeviceMenu.setText("Sound device");
        this.jSoundDeviceMenu.setToolTipText("Select an alternative sound input device");
        this.jSoundDeviceMenu.setFont(new Font("Arial", 0, 11));
        this.jSoundDeviceMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                JavaNavtexUI.this.jSoundDeviceMenuMenuSelected(evt);
            }
        });
        this.jSoundDeviceMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JavaNavtexUI.this.jSoundDeviceMenuItemStateChanged(evt);
            }
        });
        this.jSoundDeviceMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaNavtexUI.this.jSoundDeviceMenuActionPerformed(evt);
            }
        });
        this.jMenuBar1.add(this.jSoundDeviceMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.jScrollPane3, -1, 657, Short.MAX_VALUE).add(1, this.jSplitPane1, -1, 657, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jSplitPane1, -2, 76, -2).addPreferredGap(0).add(this.jScrollPane3, -1, 269, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void spectrumView1MouseDragged(MouseEvent evt) {
        this.spectrumView1.onMouseClick(evt);
        if (this.m_decoder != null) {
            this.m_decoder.setFrequency(this.spectrumView1.getFrequency(), 170.0);
        }
    }

    private void spectrumView1MouseClicked(MouseEvent evt) {
        this.spectrumView1.onMouseClick(evt);
        if (this.m_decoder != null) {
            this.m_decoder.setFrequency(this.spectrumView1.getFrequency(), 170.0);
        }
    }

    private void jSoundDeviceMenuMenuSelected(MenuEvent evt) {
    }

    private void jSoundDeviceMenuItemStateChanged(ItemEvent evt) {
    }

    private void jSoundDeviceMenuActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new JavaNavtexUI().setVisible(true);
            }
        });
    }
}

