/*
 * Decompiled with CFR 0.152.
 */
package javanavtex;

import decoder.DataTarget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.text.DecimalFormat;
import javax.swing.JComponent;

public class DataView
extends JComponent
implements DataTarget {
    protected DecimalFormat tflz;
    protected DecimalFormat tf;
    double[] m_waveData = new double[this.m_dataLength];
    int m_dataLength = 100;
    int m_ptr = 0;

    public void dataReady(double[] data, int length) {
        for (int n = 0; n < 50; ++n) {
            this.m_waveData[this.m_ptr] = data[n * (length / 50)];
            ++this.m_ptr;
            this.m_ptr %= this.m_dataLength;
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(Color.black);
        g.fillRect(0, 0, size.width, size.height);
        if (this.m_waveData == null) {
            return;
        }
        double scale = (double)size.height / 25.0;
        int offset = size.height / 2;
        int oldptr = 0;
        double xScale = (double)this.m_dataLength / (double)size.width;
        g.setColor(Color.red);
        for (int n = 1; n < size.width; ++n) {
            int ptr = (int)(xScale * (double)n);
            g.drawLine(n - 1, offset - (int)(scale * this.m_waveData[oldptr]), n, offset - (int)(scale * this.m_waveData[ptr]));
            oldptr = ptr;
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, 10);
    }
}

