/*
 * Decompiled with CFR 0.152.
 */
package dsp;

import dsp.Complex;

public class Oscillator {
    int m_sampleRate;
    double m_frequency;
    double m_realOsc;
    double m_imagOsc;
    double m_omega;
    double m_dr;
    double m_di;

    public Oscillator(int samplerate) {
        this.m_sampleRate = samplerate;
        this.m_realOsc = 1.0;
        this.m_imagOsc = 0.0;
        this.m_frequency = 0.0;
        this.m_omega = 0.0;
        this.Create();
    }

    public void SetFrequency(double f) {
        if (f <= 0.0) {
            return;
        }
        if (f == this.m_frequency) {
            return;
        }
        this.m_frequency = f;
        this.m_omega = this.m_frequency * 2.0 * Math.PI;
        this.Create();
    }

    private void Create() {
        this.m_dr = Math.cos(this.m_omega / (double)this.m_sampleRate);
        this.m_di = Math.sin(this.m_omega / (double)this.m_sampleRate);
    }

    public Complex GetValue() {
        Complex result = new Complex(this.m_realOsc, this.m_imagOsc);
        double new_real = this.m_dr * this.m_realOsc - this.m_di * this.m_imagOsc;
        double new_imag = this.m_dr * this.m_imagOsc + this.m_di * this.m_realOsc;
        double mag_y = Math.sqrt(new_real * new_real + new_imag * new_imag);
        this.m_realOsc = new_real /= mag_y;
        this.m_imagOsc = new_imag /= mag_y;
        return result;
    }
}

