/*
 * Decompiled with CFR 0.152.
 */
package dsp;

public class FIRFilter {
    int m_numCoeffs;
    double[] m_coeffs;
    double[] m_delayLine;

    public int setFilter(int len, double cutLow, double cutHigh) {
        int CoefNum = len;
        if (len % 2 == 0) {
            ++CoefNum;
        }
        int HalfLen = (CoefNum - 1) / 2;
        if (this.m_numCoeffs != CoefNum) {
            this.m_coeffs = new double[CoefNum];
            this.m_delayLine = new double[CoefNum];
            for (int k = 0; k < CoefNum; ++k) {
                this.m_delayLine[k] = 0.0;
            }
            this.m_numCoeffs = CoefNum;
        }
        if (cutLow == 0.0 && cutHigh < 1.0) {
            double TmpFloat;
            int Cnt;
            this.m_coeffs[HalfLen] = cutHigh;
            for (Cnt = 1; Cnt <= HalfLen; ++Cnt) {
                TmpFloat = Math.PI * (double)Cnt;
                this.m_coeffs[HalfLen + Cnt] = Math.sin(cutHigh * TmpFloat) / TmpFloat;
                this.m_coeffs[HalfLen - Cnt] = this.m_coeffs[HalfLen + Cnt];
            }
            TmpFloat = Math.PI * 2 / ((double)CoefNum - 1.0);
            double Sum = 0.0;
            for (Cnt = 0; Cnt < CoefNum; ++Cnt) {
                int n = Cnt;
                this.m_coeffs[n] = this.m_coeffs[n] * (0.54 - 0.46 * Math.cos(TmpFloat * (double)Cnt));
                Sum += this.m_coeffs[Cnt];
            }
            Cnt = 0;
            while (Cnt < CoefNum) {
                int n = Cnt++;
                this.m_coeffs[n] = this.m_coeffs[n] / Math.abs(Sum);
            }
            return this.m_numCoeffs;
        }
        if (cutLow > 0.0 && cutHigh == 1.0) {
            double TmpFloat;
            int Cnt;
            this.m_coeffs[HalfLen] = cutLow;
            for (Cnt = 1; Cnt <= HalfLen; ++Cnt) {
                TmpFloat = Math.PI * (double)Cnt;
                this.m_coeffs[HalfLen + Cnt] = Math.sin(cutLow * TmpFloat) / TmpFloat;
                this.m_coeffs[HalfLen - Cnt] = this.m_coeffs[HalfLen + Cnt];
            }
            TmpFloat = Math.PI * 2 / ((double)CoefNum - 1.0);
            double Sum = 0.0;
            for (Cnt = 0; Cnt < CoefNum; ++Cnt) {
                int n = Cnt;
                this.m_coeffs[n] = this.m_coeffs[n] * -(0.54 - 0.46 * Math.cos(TmpFloat * (double)Cnt));
                if (Cnt % 2 == 0) {
                    Sum += this.m_coeffs[Cnt];
                    continue;
                }
                Sum -= this.m_coeffs[Cnt];
            }
            int n = HalfLen;
            this.m_coeffs[n] = this.m_coeffs[n] + 1.0;
            Sum += 1.0;
            Cnt = 0;
            while (Cnt < CoefNum) {
                int n2 = Cnt++;
                this.m_coeffs[n2] = this.m_coeffs[n2] / Math.abs(Sum);
            }
            return this.m_numCoeffs;
        }
        if (cutLow > 0.0 && cutHigh < 1.0 && cutLow < cutHigh) {
            double TmpFloat;
            int Cnt;
            this.m_coeffs[HalfLen] = cutHigh - cutLow;
            for (Cnt = 1; Cnt <= HalfLen; ++Cnt) {
                TmpFloat = Math.PI * (double)Cnt;
                this.m_coeffs[HalfLen + Cnt] = 2.0 * Math.sin((cutHigh - cutLow) / 2.0 * TmpFloat) * Math.cos((cutHigh + cutLow) / 2.0 * TmpFloat) / TmpFloat;
                this.m_coeffs[HalfLen - Cnt] = this.m_coeffs[HalfLen + Cnt];
            }
            TmpFloat = Math.PI * 2 / ((double)CoefNum - 1.0);
            double Sum = 0.0;
            for (Cnt = 0; Cnt < CoefNum; ++Cnt) {
                int n = Cnt;
                this.m_coeffs[n] = this.m_coeffs[n] * (0.54 - 0.46 * Math.cos(TmpFloat * (double)Cnt));
                Sum += this.m_coeffs[Cnt];
            }
            Cnt = 0;
            while (Cnt < CoefNum) {
                int n = Cnt++;
                this.m_coeffs[n] = this.m_coeffs[n] / Math.abs(Sum);
            }
            return this.m_numCoeffs;
        }
        if (cutLow > 0.0 && cutHigh < 1.0 && cutLow > cutHigh) {
            double TmpFloat;
            int Cnt;
            this.m_coeffs[HalfLen] = cutLow - cutHigh;
            for (Cnt = 1; Cnt <= HalfLen; ++Cnt) {
                TmpFloat = Math.PI * (double)Cnt;
                this.m_coeffs[HalfLen + Cnt] = 2.0 * Math.sin((cutLow - cutHigh) / 2.0 * TmpFloat) * Math.cos((cutHigh + cutLow) / 2.0 * TmpFloat) / TmpFloat;
                this.m_coeffs[HalfLen - Cnt] = this.m_coeffs[HalfLen + Cnt];
            }
            TmpFloat = Math.PI * 2 / ((double)CoefNum - 1.0);
            double Sum = 0.0;
            for (Cnt = 0; Cnt < CoefNum; ++Cnt) {
                int n = Cnt;
                this.m_coeffs[n] = this.m_coeffs[n] * -(0.54 - 0.46 * Math.cos(TmpFloat * (double)Cnt));
                Sum += this.m_coeffs[Cnt];
            }
            int n = HalfLen;
            this.m_coeffs[n] = this.m_coeffs[n] + 1.0;
            Sum += 1.0;
            Cnt = 0;
            while (Cnt < CoefNum) {
                int n3 = Cnt++;
                this.m_coeffs[n3] = this.m_coeffs[n3] / Math.abs(Sum);
            }
            return this.m_numCoeffs;
        }
        return this.m_numCoeffs;
    }

    public double[] filter(double[] io, int len) {
        for (int i = 0; i < len; ++i) {
            int k;
            this.m_delayLine[0] = io[i];
            double accumulator = 0.0;
            for (k = 0; k < this.m_numCoeffs; ++k) {
                accumulator += this.m_coeffs[k] * this.m_delayLine[k];
            }
            io[i] = accumulator;
            for (k = this.m_numCoeffs - 1; k > 0; --k) {
                this.m_delayLine[k] = this.m_delayLine[k - 1];
            }
        }
        return io;
    }
}

