/*
 * Decompiled with CFR 0.152.
 */
package dsp;

import dsp.Complex;

public class FFT {
    public static Complex[] fft(Complex[] x) {
        int N = x.length;
        if (N == 1) {
            return new Complex[]{x[0]};
        }
        if (N % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        Complex[] even = new Complex[N / 2];
        for (int k = 0; k < N / 2; ++k) {
            even[k] = x[2 * k];
        }
        Complex[] q = FFT.fft(even);
        Complex[] odd = even;
        for (int k = 0; k < N / 2; ++k) {
            odd[k] = x[2 * k + 1];
        }
        Complex[] r = FFT.fft(odd);
        Complex[] y = new Complex[N];
        for (int k = 0; k < N / 2; ++k) {
            double kth = (double)(-2 * k) * Math.PI / (double)N;
            Complex wk = new Complex(Math.cos(kth), Math.sin(kth));
            y[k] = q[k].plus(wk.times(r[k]));
            y[k + N / 2] = q[k].minus(wk.times(r[k]));
        }
        return y;
    }

    public static Complex[] ifft(Complex[] x) {
        int i;
        int N = x.length;
        Complex[] y = new Complex[N];
        for (i = 0; i < N; ++i) {
            y[i] = x[i].conjugate();
        }
        y = FFT.fft(y);
        for (i = 0; i < N; ++i) {
            y[i] = y[i].conjugate();
        }
        for (i = 0; i < N; ++i) {
            y[i] = y[i].times(1.0 / (double)N);
        }
        return y;
    }

    public static Complex[] cconvolve(Complex[] x, Complex[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("Dimensions don't agree");
        }
        int N = x.length;
        Complex[] a = FFT.fft(x);
        Complex[] b = FFT.fft(y);
        Complex[] c = new Complex[N];
        for (int i = 0; i < N; ++i) {
            c[i] = a[i].times(b[i]);
        }
        return FFT.ifft(c);
    }

    public static Complex[] convolve(Complex[] x, Complex[] y) {
        int i;
        int i2;
        Complex ZERO = new Complex(0.0, 0.0);
        Complex[] a = new Complex[2 * x.length];
        for (i2 = 0; i2 < x.length; ++i2) {
            a[i2] = x[i2];
        }
        for (i2 = x.length; i2 < 2 * x.length; ++i2) {
            a[i2] = ZERO;
        }
        Complex[] b = new Complex[2 * y.length];
        for (i = 0; i < y.length; ++i) {
            b[i] = y[i];
        }
        for (i = y.length; i < 2 * y.length; ++i) {
            b[i] = ZERO;
        }
        return FFT.cconvolve(a, b);
    }
}

