/*
 * Decompiled with CFR 0.152.
 */
package dsp;

import dsp.FIRFilter;

public class Downsampler {
    int m_factor;
    FIRFilter m_filter;

    public Downsampler(int factor) {
        this.m_factor = factor;
        this.m_filter = new FIRFilter();
        this.m_filter.setFilter(32, 0.0, 1.0 / (double)factor);
    }

    public double[] resample(double[] data, int length) {
        int resample_length = length / this.m_factor;
        if (resample_length == 0) {
            return null;
        }
        double[] result = new double[resample_length];
        data = this.m_filter.filter(data, length);
        int n = 0;
        int i = 0;
        while (n < resample_length) {
            result[n] = data[i];
            ++n;
            i += this.m_factor;
        }
        return result;
    }
}

