/*
 * Decompiled with CFR 0.152.
 */
package dsp;

import dsp.BitConvolution;
import dsp.Complex;
import dsp.Oscillator;

public class CorrelationDemodulator {
    double m_frequency;
    int m_sampleRate;
    Oscillator m_osc;
    BitConvolution m_Iconvolution;
    BitConvolution m_Qconvolution;

    public CorrelationDemodulator(int samplerate) {
        this.m_sampleRate = samplerate;
        this.m_frequency = 0.0;
        this.m_osc = new Oscillator(this.m_sampleRate);
        this.m_Iconvolution = new BitConvolution(90);
        this.m_Qconvolution = new BitConvolution(90);
    }

    public void setFrequency(double f) {
        this.m_frequency = f;
        this.m_osc.SetFrequency(this.m_frequency);
    }

    public double[] demodulate(double[] data, int length) {
        double[] result = new double[length];
        for (int n = 0; n < length; ++n) {
            Complex localOsc = this.m_osc.GetValue();
            double I = localOsc.Re();
            double Q = localOsc.Im();
            I *= data[n];
            Q *= data[n];
            I = this.m_Iconvolution.Convolve(I);
            Q = this.m_Qconvolution.Convolve(Q);
            I *= I;
            Q *= Q;
            result[n] = I + Q;
        }
        return result;
    }
}

