/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import dsp.BitConvolution;

public class NAVTEXDecoder {
    private static final char FIGS = '6';
    private static final char LTRS = 'Z';
    private static final char ALPHA = '\u000f';
    private static final char BETA = '3';
    private static final char[] CCIR_unshifted = new char[]{'*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '%', '*', '*', '*', '*', '*', '*', '*', 'J', '*', '*', '*', 'F', '*', 'C', 'K', '*', '*', '*', '*', '*', '*', '*', '*', 'W', '*', '*', '*', 'Y', '*', 'P', 'Q', '*', '*', '*', '*', '%', '*', 'G', '%', '*', '*', 'M', 'X', '*', 'V', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', 'A', '*', '*', '*', 'S', '*', 'I', 'U', '*', '*', '*', '*', 'D', '*', 'R', 'E', '*', '*', 'N', '%', '*', ' ', '*', '*', '*', '*', '*', '*', 'Z', '*', 'L', '%', '*', '*', 'H', ' ', '*', '%', '*', '*', '*', '*', 'O', 'B', '*', 'T', '*', '*', '*', '\r', '*', '*', '*', '*', '*', '*', '*'};
    private static final char[] CCIR_shifted = new char[]{'*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '%', '*', '*', '*', '*', '*', '*', '*', '\\', '*', '*', '*', '!', '*', ':', '(', '*', '*', '*', '*', '*', '*', '*', '*', '2', '*', '*', '*', '6', '*', '0', '1', '*', '*', '*', '*', '%', '*', '&', '%', '*', '*', '.', '/', '*', '=', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '-', '*', '*', '*', '\'', '*', '8', '7', '*', '*', '*', '*', '$', '*', '4', '3', '*', '*', ',', '%', '*', ' ', '*', '*', '*', '*', '*', '*', '+', '*', ')', '%', '*', '*', '#', '*', '*', '%', '*', '*', '*', '*', '9', '?', '*', '5', '*', '*', '*', '\r', '*', '*', '*', '*', '*', '*', '*'};
    int m_sampleRate;
    int m_bitLength;
    boolean m_lastBit;
    int m_bitcount;
    int m_period;
    long m_oldGroup;
    long m_group;
    long m_shiftreg;
    boolean m_inPhase;
    int m_currentBit;
    boolean m_bGotPair;
    boolean m_bLTRS;
    int m_error_count;
    int m_errors;
    int m_chars;
    char[] group;
    public static final int BIT_RATE = 100;
    BitConvolution m_bitConvolution;

    public NAVTEXDecoder(int sampleRate) {
        this.m_sampleRate = sampleRate;
        this.m_bitLength = this.m_sampleRate / 100;
        this.m_bitConvolution = new BitConvolution(100);
        this.m_lastBit = false;
        this.m_bitcount = 0;
        this.m_period = this.m_bitLength;
        this.m_inPhase = false;
        this.m_bGotPair = false;
        this.m_bLTRS = true;
        this.group = new char[6];
    }

    public String decode(double[] data, int length) {
        String result = new String();
        for (int n = 0; n < length; ++n) {
            boolean new_bit;
            double convolutionOutput = this.m_bitConvolution.Convolve(data[n]);
            boolean bl = new_bit = convolutionOutput > 0.0;
            if (this.m_lastBit != new_bit) {
                this.m_lastBit = new_bit;
                int clockError = this.m_bitcount % this.m_period;
                clockError = clockError < this.m_period / 2 ? -clockError : this.m_period - clockError;
                int clockAdjust = clockError / 5;
                this.m_bitcount = clockAdjust == 0 ? 0 : (this.m_bitcount += clockAdjust);
            }
            if (this.m_bitcount % this.m_period == this.m_period / 2) {
                result = result + this.GotBit(this.m_lastBit);
            }
            ++this.m_bitcount;
        }
        return result;
    }

    protected String GotBit(boolean bit) {
        String decodedString = new String();
        this.m_oldGroup >>= 1;
        this.m_oldGroup = (this.m_group & 1L) == 1L ? (this.m_oldGroup |= 0x20000000000L) : (this.m_oldGroup |= 0L);
        this.m_group >>= 1;
        this.m_group = bit ? (this.m_group |= 0x20000000000L) : (this.m_group |= 0L);
        this.m_shiftreg <<= 1;
        this.m_shiftreg |= bit ? 1L : 0L;
        this.group[5] = (char)(this.m_group & 0x7FL);
        this.group[4] = (char)(this.m_group >> 7 & 0x7FL);
        this.group[3] = (char)(this.m_group >> 14 & 0x7FL);
        this.group[2] = (char)(this.m_group >> 21 & 0x7FL);
        this.group[1] = (char)(this.m_group >> 28 & 0x7FL);
        this.group[0] = (char)(this.m_group >> 35 & 0x7FL);
        boolean validChar = false;
        if (this.group[0] == this.group[5] && this.IsValidChar(this.group[0]) && this.IsValidChar(this.group[5]) && this.CCIR2ASCII(this.group[0]) != '\uffffffff') {
            validChar = true;
        }
        if (!this.m_inPhase && this.group[0] == this.group[5]) {
            this.m_currentBit = 0;
            this.m_inPhase = true;
            this.m_bGotPair = true;
            this.m_bLTRS = true;
            String s = new String();
            this.GotChar('3');
            decodedString.concat(s);
        } else {
            ++this.m_currentBit;
            this.m_currentBit %= 7;
            if (this.m_currentBit == 0) {
                String s = this.GotChar(this.group[0]);
                decodedString = decodedString + s;
                if (s.length() > 0 && s.charAt(0) == '*') {
                    ++this.m_error_count;
                    if (this.m_error_count > 1) {
                        this.m_currentBit = 6;
                        this.m_bGotPair = false;
                        this.m_bLTRS = true;
                    }
                    ++this.m_errors;
                    return "";
                }
            }
        }
        return decodedString;
    }

    protected char CCIR2ASCII(char ccir) {
        ccir = (char)(ccir & 0x7F);
        if (this.m_bLTRS) {
            return CCIR_unshifted[ccir];
        }
        return CCIR_shifted[ccir];
    }

    protected String GotChar(char ch) {
        boolean bl = this.m_bGotPair = !this.m_bGotPair;
        if (this.m_bGotPair) {
            if (this.group[0] == this.group[5] && this.IsValidChar(this.group[0]) && this.IsValidChar(this.group[5])) {
                char decoded = this.CCIR2ASCII(this.group[0]);
                if (decoded != '\uffffffff') {
                    if (this.group[0] == '6') {
                        this.m_bLTRS = false;
                    }
                    if (this.group[0] == 'Z') {
                        this.m_bLTRS = true;
                    }
                    if (decoded != '%') {
                        String str = String.format("%c", Character.valueOf(decoded));
                        if (decoded == '\r') {
                            str = str + '\n';
                        }
                        return str;
                    }
                }
                return "";
            }
            if (this.group[0] == '\u000f' || this.group[0] == '3') {
                return "";
            }
            return "*";
        }
        return "";
    }

    protected boolean IsValidChar(char ch) {
        return CCIR_unshifted[ch] != '*';
    }
}

