/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import audiohelpers.WaveTarget;
import decoder.SpectrumTarget;
import dsp.Complex;
import dsp.FFT;

public class FFTThread
extends Thread
implements WaveTarget {
    double[] m_waveData = null;
    double[] m_spectrum;
    int m_dataLength;
    boolean m_isReady = true;
    double m_cursorFrequency;
    double m_deviation;
    int m_sampleRate;
    SpectrumTarget m_spectrumTarget;
    public static final Object m_lock = new Object();
    boolean done = false;

    public FFTThread(SpectrumTarget st) {
        this.m_spectrumTarget = st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (!this.done) {
            Object object = m_lock;
            synchronized (object) {
                try {
                    int n;
                    m_lock.wait();
                    Complex[] x = new Complex[this.m_dataLength];
                    for (n = 0; n < this.m_dataLength; ++n) {
                        x[n] = new Complex(this.m_waveData[n], 0.0);
                    }
                    Complex[] X = FFT.fft(x);
                    this.m_spectrum = new double[this.m_dataLength / 2];
                    double max = 0.0;
                    double min = 0.0;
                    for (n = 0; n < this.m_dataLength / 2; ++n) {
                        this.m_spectrum[n] = Math.log10(Math.sqrt(X[n].Re() * X[n].Re() + X[n].Im() * X[n].Im()));
                        if (this.m_spectrum[n] > max) {
                            max = this.m_spectrum[n];
                        }
                        if (!(this.m_spectrum[n] < min)) continue;
                        min = this.m_spectrum[n];
                    }
                    this.m_spectrum[0] = this.m_spectrum[2];
                    this.m_spectrum[1] = this.m_spectrum[3];
                    max -= min;
                    n = 0;
                    while (n < this.m_dataLength / 2) {
                        int n2 = n;
                        this.m_spectrum[n2] = this.m_spectrum[n2] - min;
                        int n3 = n++;
                        this.m_spectrum[n3] = this.m_spectrum[n3] / max;
                    }
                    this.m_spectrumTarget.spectrumReady(this.m_spectrum, this.m_dataLength / 2);
                    this.m_isReady = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waveReady(double[] data, int length) {
        Object object = m_lock;
        synchronized (object) {
            this.m_isReady = false;
            this.m_waveData = data;
            this.m_dataLength = length;
            m_lock.notify();
        }
    }
}

