/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import audiohelpers.WaveTarget;
import decoder.BFSKDemodulator;
import decoder.DataTarget;
import decoder.NAVTEXDecoder;
import decoder.TextTarget;

public class DecoderThread
extends Thread
implements WaveTarget {
    BFSKDemodulator demodulator;
    DataTarget m_dataTarget;
    TextTarget m_textTarget;
    NAVTEXDecoder decoder;
    boolean m_bDecoding = false;
    double[] m_waveData = null;
    int m_iLength = 0;
    public static final Object m_lock = new Object();

    public DecoderThread(int samplerate, double f, double deviation, DataTarget dt, TextTarget tt) {
        this.demodulator = new BFSKDemodulator(samplerate, f, deviation);
        this.decoder = new NAVTEXDecoder(samplerate);
        this.m_dataTarget = dt;
        this.m_textTarget = tt;
        this.start();
    }

    public void setFrequency(double f, double deviation) {
        this.demodulator.setFrequency(f, deviation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object = m_lock;
            synchronized (object) {
                try {
                    m_lock.wait();
                    double[] decodedData = this.demodulator.demodulate(this.m_waveData, this.m_iLength);
                    String decodedString = this.decoder.decode(decodedData, this.m_iLength);
                    if (decodedString.length() > 0) {
                        this.m_textTarget.textReady(decodedString);
                    }
                    this.m_dataTarget.dataReady(decodedData, this.m_iLength);
                    this.m_bDecoding = false;
                }
                catch (InterruptedException exp) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waveReady(double[] data, int length) {
        Object object = m_lock;
        synchronized (object) {
            this.m_bDecoding = true;
            this.m_waveData = data;
            this.m_iLength = length;
            m_lock.notify();
        }
    }
}

