/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import dsp.CorrelationDemodulator;
import dsp.FIRFilter;

public class BFSKDemodulator {
    static final int FIR_FILTER_LENGTH = 128;
    int m_sampleRate;
    double m_scale;
    CorrelationDemodulator m_markDemodulator;
    CorrelationDemodulator m_spaceDemodulator;
    FIRFilter m_markFilter;
    FIRFilter m_spaceFilter;
    FIRFilter m_basebandFilter;
    FIRFilter m_bandpassFilter;

    public BFSKDemodulator(int samplerate, double f, double deviation) {
        this.m_sampleRate = samplerate;
        this.m_markDemodulator = new CorrelationDemodulator(this.m_sampleRate);
        this.m_spaceDemodulator = new CorrelationDemodulator(this.m_sampleRate);
        this.m_markFilter = new FIRFilter();
        this.m_spaceFilter = new FIRFilter();
        this.m_scale = 1.0 / ((double)this.m_sampleRate / 2.0);
        this.m_basebandFilter = new FIRFilter();
        this.m_basebandFilter.setFilter(128, 0.0, this.m_scale * 100.0);
        this.m_bandpassFilter = new FIRFilter();
        this.setFrequency(f, deviation);
    }

    public void setFrequency(double f, double deviation) {
        this.m_markDemodulator.setFrequency(f + deviation / 2.0);
        this.m_spaceDemodulator.setFrequency(f - deviation / 2.0);
        this.m_bandpassFilter.setFilter(128, this.m_scale * (f - deviation / 2.0), this.m_scale * (f + deviation / 2.0));
    }

    public double[] demodulate(double[] waveData, int length) {
        int n;
        double[] markDemod = this.m_markDemodulator.demodulate(waveData, length);
        double[] spaceDemod = this.m_spaceDemodulator.demodulate(waveData, length);
        double[] result = new double[length];
        for (n = 0; n < length; ++n) {
            result[n] = markDemod[n] - spaceDemod[n];
        }
        result = this.m_basebandFilter.filter(result, length);
        for (n = 0; n < length; ++n) {
            if (result[n] != 0.0) {
                if (result[n] > 0.0) {
                    result[n] = Math.log(result[n]);
                    continue;
                }
                result[n] = -Math.log(-result[n]);
                continue;
            }
            result[n] = Math.log(1.0E-5);
        }
        return result;
    }
}

