/*
 * Decompiled with CFR 0.152.
 */
package audiohelpers;

import audiohelpers.WaveTarget;
import dsp.Downsampler;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class AudioUtils
extends Thread {
    public static final String m_waveReadyEvent = "WAVE_READY";
    private static boolean DEBUG = false;
    public static TargetDataLine m_targetDataLine;
    public static int m_iSampleRate;
    public static int m_iBlockSize;
    private static boolean m_bRecording;
    private static WaveTarget m_waveTarget;
    public static final Object m_lock;
    private int OVERSAMPLE_RATE;
    Downsampler m_downsampler;
    private long m_time = 0L;
    private long MAX_TIME;
    byte[] buffer;
    double[] outBuffer;

    public AudioUtils(int base_sample_rate, int oversampling) {
        this.OVERSAMPLE_RATE = oversampling;
        this.m_downsampler = new Downsampler(this.OVERSAMPLE_RATE);
        m_iSampleRate = base_sample_rate * this.OVERSAMPLE_RATE;
        m_iBlockSize = 4096 * this.OVERSAMPLE_RATE;
        m_bRecording = false;
        this.buffer = new byte[m_iBlockSize];
        this.outBuffer = new double[m_iBlockSize / 2];
        this.MAX_TIME = (long)(1000.0 * ((double)m_iBlockSize / (double)m_iSampleRate));
    }

    public void run() {
        while (m_bRecording) {
            if (this.m_time != 0L && System.currentTimeMillis() - this.m_time > this.MAX_TIME) {
                m_waveTarget.waveReady(null, -1);
            }
            int bytesRead = m_targetDataLine.read(this.buffer, 0, m_iBlockSize);
            this.m_time = System.currentTimeMillis();
            if (bytesRead != m_iBlockSize) continue;
            double[] outBuffer = new double[m_iBlockSize / 2];
            for (int n = 0; n < m_iBlockSize / 2; ++n) {
                short value = this.buffer[n * 2 + 1];
                value = (short)(value << 8);
                value = (short)(value | this.buffer[n * 2] & 0xFF);
                outBuffer[n] = (double)value / 32768.0;
            }
            if (this.OVERSAMPLE_RATE > 1) {
                outBuffer = this.m_downsampler.resample(outBuffer, m_iBlockSize / 2);
            }
            m_waveTarget.waveReady(outBuffer, m_iBlockSize / 2 / this.OVERSAMPLE_RATE);
        }
        m_bRecording = true;
    }

    public static void setDebug(boolean bDebug) {
        DEBUG = bDebug;
    }

    public static int getDeviceName(int deviceIndex, String[] deviceName) {
        Mixer.Info[] aInfos = AudioSystem.getMixerInfo();
        if (deviceIndex < aInfos.length) {
            deviceName[0] = new String(aInfos[deviceIndex].getName());
            return 1;
        }
        return 0;
    }

    public boolean StartAudio(String deviceName, WaveTarget wavetarget) {
        if (m_bRecording) {
            this.StopAudio();
        }
        AudioFormat format = new AudioFormat(m_iSampleRate, 16, 1, true, false);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
        m_targetDataLine = null;
        try {
            m_targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            m_targetDataLine.open(format);
        }
        catch (LineUnavailableException e) {
            m_targetDataLine = null;
        }
        catch (IllegalArgumentException ex) {
            m_targetDataLine = null;
        }
        if (m_targetDataLine == null) {
            return false;
        }
        m_targetDataLine.start();
        m_waveTarget = wavetarget;
        m_bRecording = true;
        this.start();
        return true;
    }

    public void StopAudio() {
        if (!m_bRecording) {
            return;
        }
        if (m_targetDataLine == null) {
            return;
        }
        m_targetDataLine.stop();
        m_targetDataLine.close();
        m_bRecording = false;
        try {
            while (!m_bRecording) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static TargetDataLine getTargetDataLine(String strMixerName, AudioFormat audioFormat, int nBufferSize) {
        block11: {
            m_targetDataLine = null;
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat, nBufferSize);
            try {
                if (strMixerName != null) {
                    Mixer.Info mixerInfo = AudioUtils.getMixerInfo(strMixerName);
                    if (mixerInfo == null) {
                        AudioUtils.out("AudioCommon.getTargetDataLine(): mixer not found: " + strMixerName);
                        return null;
                    }
                    Mixer mixer = AudioSystem.getMixer(mixerInfo);
                    m_targetDataLine = (TargetDataLine)mixer.getLine(info);
                } else {
                    if (DEBUG) {
                        AudioUtils.out("AudioCommon.getTargetDataLine(): using default mixer");
                    }
                    m_targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
                }
                if (DEBUG) {
                    AudioUtils.out("AudioCommon.getTargetDataLine(): opening line...");
                }
                m_targetDataLine.open(audioFormat, nBufferSize);
                if (DEBUG) {
                    AudioUtils.out("AudioCommon.getTargetDataLine(): opened line");
                }
            }
            catch (LineUnavailableException e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block11;
                e.printStackTrace();
            }
        }
        if (DEBUG) {
            AudioUtils.out("AudioCommon.getTargetDataLine(): returning line: " + m_targetDataLine);
        }
        return m_targetDataLine;
    }

    public static boolean isPcm(AudioFormat.Encoding encoding) {
        return encoding.equals(AudioFormat.Encoding.PCM_SIGNED) || encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED);
    }

    private static void out(String strMessage) {
    }

    public static Mixer.Info getMixerInfo(String strMixerName) {
        Mixer.Info[] aInfos = AudioSystem.getMixerInfo();
        for (int i = 0; i < aInfos.length; ++i) {
            if (!aInfos[i].getName().equals(strMixerName)) continue;
            return aInfos[i];
        }
        return null;
    }

    static {
        m_lock = new Object();
    }
}

